; Given a dfa in the representation generated by regexp.sch,
; construct a lexical analyzer written in C.
; The states are integers beginning with 0.
; For the moment, comments and whitespace must be handled
; by editing the generated C code.
; Also character classes such as letters and digits are best
; handled by editing the generated C code.
;
; In short, this is quick-and-dirty code to save me the trouble
; of writing lexical analyzers in C for my compiler classes.
; I'll clean it up later, and make it more general.
;
; Uses output routines from ParseGen:parsegen.c.sch.

; Inelegant hacks.
; Whitespace is handled specially.
; The following symbols are recognized and treated specially:
;    letter
;    digit

(define character-classes
  '((letter isalpha)
    (digit isdigit)))

(define (generate-c-for-lexer dfa)
  (let ((dfa (mysort (lambda (entry1 entry2)
                       (let ((blocked1? (null? (nfa-entry-transitions entry1)))
                             (blocked2? (null? (nfa-entry-transitions entry2))))
                         (or (eq? entry1 (car dfa))
                             (and (not blocked1?) blocked2?)
                             (and (not blocked1?)
                                  (not blocked2?)
                                  (<= (nfa-entry-state entry1)
                                      (nfa-entry-state entry2)))
                             (and blocked1?
                                  blocked2?
                                  (<= (nfa-entry-state entry1)
                                      (nfa-entry-state entry2))))))
                     dfa)))
    (gen-c 0 "token scanner0() {" #\newline)
    (gen-c 0 "    int state = 0\;" #\newline)
    (gen-c 0 "    char c = scanChar()\;" #\newline)
    (gen-c 0 #\newline)
    (gen-c 0 "    /*  Edit here to consume whitespace.  */" #\newline)
    (gen-c 0 "    while (isspace(c)) {" #\newline)
    (gen-c 0 "        consumeChar()\;" #\newline)
    (gen-c 0 "        string_accumulator_size = 0\;" #\newline)
    (gen-c 0 "        c = scanChar()\;" #\newline)
    (gen-c 0 "    }" #\newline)
    (gen-c 0 #\newline)
    (gen-c 0 "    if (c == EOF)" #\newline)
    (gen-c 0 "        return accept(zeof)\;" #\newline)
    (gen-c 0 "    else do switch (state) {" #\newline)
    (for-each (lambda (entry)
                (generate-c-for-lexer-state entry dfa))
              dfa)
    (gen-c 0 "        default:" #\newline)
    (gen-c 0 "            return scannerError(errIllegalChar)\;" #\newline)
    (gen-c 0 "    } while (state >= 0)\;" #\newline)
    (gen-c 0 "    return scannerError(errLexGenBug)\;" #\newline)
    (gen-c 0 "}" #\newline)
    (gen-c 0 #\newline)))

(define (generate-c-for-lexer-state entry dfa)
  (let ((transitions (nfa-entry-transitions entry))
        (gen-transition (lambda (t)
                          (generate-c-for-lexer-transition t dfa)))
        (char-transition? (lambda (t)
                            (char? (transition-token t))))
        (symbol-transition? (lambda (t)
                              (not (char? (transition-token t))))))
    (if (not (null? transitions))
        (begin
         (gen-c 8 "case " (nfa-entry-state entry) ":" #\newline)
         (gen-c 8 "    switch (c) {" #\newline)
         (for-each gen-transition
                   (filter char-transition? transitions))
         (gen-c 8 "        default:" #\newline)
         (for-each gen-transition
                   (filter symbol-transition? transitions))
         (generate-c-for-blocked-state 20 entry)
         (gen-c 8 "    }" #\newline)
         (gen-c 8 "    break\;" #\newline)))))

(define (generate-c-for-blocked-state n entry)
  (let ((accepts (nfa-entry-accepts entry)))
    (cond ((or (not accepts)
               (null? accepts))
           (gen-c n "return scannerError(errIncompleteToken)\;" #\newline))
          ((eq? accepts 'whitespace)
           (gen-c n "string_accumulator_size = 0\;" #\newline)
           (gen-c n "c = scanChar()\;" #\newline)
           (gen-c n "state = 0\;" #\newline)
           (gen-c n "break\;" #\newline))
          ((symbol? accepts)
           (gen-c n "return accept("
                    (string-append "z" (symbol->string accepts))
                    ")\;"
                    #\newline)
           (gen-c n "break\;" #\newline))
          ((and (pair? accepts) (symbol? (car accepts)))
           (generate-c-for-blocked-state
            n
            (make-nfa-entry (nfa-entry-state entry)
                            (car accepts)
                            '())))
          (else
           (gen-c n "/*  WHAT GOES HERE?  */" #\newline)
           (gen-c n "state = -1\;" #\newline)
           (gen-c n "break\;" #\newline)))))

(define (generate-c-for-lexer-transition transition dfa)
  (let* ((token (transition-token transition))
         (target (transition-target transition))
         (entry (select (lambda (entry)
                          (eqv? target (nfa-entry-state entry)))
                        dfa)))
    (if (char? token)
        (begin
         (gen-c 16 "case '" (transition-token transition) "':" #\newline)
         (gen-c 16 "    consumeChar()\;" #\newline)
         (if (null? (nfa-entry-transitions entry))
             (generate-c-for-blocked-state 20 entry)
             (begin
              (gen-c 16 "    c = scanChar()\;" #\newline)
              (gen-c 16 "    state = " target "\;" #\newline)
              (gen-c 16 "    break\;" #\newline))))
        (let ((handler (assq token character-classes)))
          (if handler
              (gen-c 16 "    if (" (cadr handler) "(c)) {" #\newline)
              (gen-c 16 "    {   /*  " token "  */" #\newline))
          (gen-c 16 "        consumeChar()\;" #\newline)
          (if (null? (nfa-entry-transitions entry))
              (generate-c-for-blocked-state 24 entry)
              (begin
               (gen-c 16 "        c = scanChar()\;" #\newline)
               (gen-c 16 "        state = " target "\;" #\newline)
               (gen-c 16 "        break\;" #\newline)))
          (gen-c 16 "    } else" #\newline)))))

; To do:
;
; Transitions to states that always block can be replaced by in-line code.
; Then the cases for such states are never used.
; (This assumes the start state is not such a state, but big deal.)
;
; Handling of output-port1.
;
; Messages for scannerError.
;
; Handling of letter and digit classes.
; Probably should handle them in a default case using
; isdigit and isalpha.
; Whitespace should probably be handled the same way.
