;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; $Id$
;;;
;;; State machine for R7RS syntax with R6RS and Larceny extensions.
;;;
;;; The bulk of the code for this state machine was generated by
;;; Will Clinger's LexGen and ParseGen, so the state machine can
;;; be extended or customized by regenerating that code.
;;;
;;; LexGen and ParseGen are available at
;;; https://github.com/larcenists/larceny/tree/master/tools
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (make-state-machine clear-string-accumulator!
                            scanChar consumeChar accept
                            scannerError errIncompleteToken)

  ;;; FIXME:  This is a hack, but it avoids any changes to LexGen.

  (define (set! ignored also-ignored)
    (clear-string-accumulator!))

  (define string_accumulator_length 'ignored)

  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;
  ; LexGen generated the code for the state machine.
  ;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  
  (define (state0 c)
    (case c
      ((#\`) (consumeChar) (accept 'backquote))
      ((#\') (consumeChar) (accept 'quote))
      ((#\]) (consumeChar) (accept 'rbracket))
      ((#\[) (consumeChar) (accept 'lbracket))
      ((#\)) (consumeChar) (accept 'rparen))
      ((#\() (consumeChar) (accept 'lparen))
      ((#\tab #\newline #\vtab #\page #\return #\space)
       (consumeChar)
       (begin
         (set! string_accumulator_length 0)
         (state0 (scanChar))))
      ((#\;) (consumeChar) (state210 (scanChar)))
      ((#\#) (consumeChar) (state209 (scanChar)))
      ((#\0 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state134 (scanChar)))
      ((#\+) (consumeChar) (state76 (scanChar)))
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\@)
       (consumeChar)
       (state74 (scanChar)))
      ((#\-) (consumeChar) (state19 (scanChar)))
      ((#\1) (consumeChar) (state16 (scanChar)))
      ((#\.) (consumeChar) (state15 (scanChar)))
      ((#\,) (consumeChar) (state14 (scanChar)))
      ((#\\) (consumeChar) (state13 (scanChar)))
      ((#\|) (consumeChar) (state12 (scanChar)))
      ((#\") (consumeChar) (state8 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c) (char=? c (integer->char 171))))
            c)
           (begin (consumeChar) (state4 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if (eof-object? c)
                   (begin (consumeChar) (accept 'eofobj))
                   (if ((lambda (c) (and (char? c) (char-whitespace? c)))
                        c)
                       (begin
                         (consumeChar)
                         (begin
                           (set! string_accumulator_length 0)
                           (state0 (scanChar))))
                       (if ((lambda (c)
                              (and (char? c) (char=? c (integer->char 133))))
                            c)
                           (begin
                             (consumeChar)
                             (begin
                               (set! string_accumulator_length 0)
                               (state0 (scanChar))))
                           (scannerError errIncompleteToken)))))))))
  (define (state1 c)
    (case c
      ((#\newline #\return)
       (consumeChar)
       (state4 (scanChar)))
      ((#\\) (consumeChar) (state3 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state1 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c) (char=? c (integer->char 187))))
            c)
           (begin (consumeChar) (accept 'text))
           (if ((lambda (c)
                  (and (char? c)
                       (not (char=? c (integer->char 187)))))
                c)
               (begin (consumeChar) (state4 (scanChar)))
               (if ((lambda (c)
                      (and (char? c) (char=? c (integer->char 8232))))
                    c)
                   (begin (consumeChar) (state4 (scanChar)))
                   (if ((lambda (c)
                          (and (char? c) (char=? c (integer->char 133))))
                        c)
                       (begin (consumeChar) (state4 (scanChar)))
                       (scannerError errIncompleteToken))))))))
  (define (state2 c)
    (case c
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state1 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state3 c)
    (case c
      ((#\a
        #\b
        #\t
        #\n
        #\v
        #\f
        #\r
        #\"
        #\\
        #\newline
        #\return
        #\space)
       (consumeChar)
       (state4 (scanChar)))
      ((#\x) (consumeChar) (state2 (scanChar)))
      (else
       (if (char? c)
           (begin (consumeChar) (state4 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (char=? c (integer->char 8232))))
                c)
               (begin (consumeChar) (state4 (scanChar)))
               (if ((lambda (c)
                      (and (char? c) (char=? c (integer->char 133))))
                    c)
                   (begin (consumeChar) (state4 (scanChar)))
                   (if ((lambda (c)
                          (and (char? c) (char=? c (integer->char 187))))
                        c)
                       (begin (consumeChar) (state4 (scanChar)))
                       (if ((lambda (c)
                              (and (char? c) (char=? c (integer->char 171))))
                            c)
                           (begin (consumeChar) (state4 (scanChar)))
                           (scannerError errIncompleteToken)))))))))
  (define (state4 c)
    (case c
      ((#\newline #\return)
       (consumeChar)
       (state4 (scanChar)))
      ((#\\) (consumeChar) (state3 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c) (char=? c (integer->char 187))))
            c)
           (begin (consumeChar) (accept 'text))
           (if ((lambda (c)
                  (and (char? c)
                       (not (char=? c (integer->char 187)))))
                c)
               (begin (consumeChar) (state4 (scanChar)))
               (if ((lambda (c)
                      (and (char? c) (char=? c (integer->char 8232))))
                    c)
                   (begin (consumeChar) (state4 (scanChar)))
                   (if ((lambda (c)
                          (and (char? c) (char=? c (integer->char 133))))
                        c)
                       (begin (consumeChar) (state4 (scanChar)))
                       (scannerError errIncompleteToken))))))))
  (define (state5 c)
    (case c
      ((#\") (consumeChar) (accept 'string))
      ((#\newline #\return)
       (consumeChar)
       (state8 (scanChar)))
      ((#\\) (consumeChar) (state7 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state5 (scanChar)))
      (else (begin (consumeChar) (state8 (scanChar))))))
  (define (state6 c)
    (case c
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state5 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state7 c)
    (case c
      ((#\a
        #\b
        #\t
        #\n
        #\v
        #\f
        #\r
        #\"
        #\\
        #\newline
        #\return
        #\space)
       (consumeChar)
       (state8 (scanChar)))
      ((#\x) (consumeChar) (state6 (scanChar)))
      (else
       (if (char? c)
           (begin (consumeChar) (state8 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (char=? c (integer->char 8232))))
                c)
               (begin (consumeChar) (state8 (scanChar)))
               (if ((lambda (c)
                      (and (char? c) (char=? c (integer->char 133))))
                    c)
                   (begin (consumeChar) (state8 (scanChar)))
                   (if ((lambda (c)
                          (and (char? c) (char=? c (integer->char 187))))
                        c)
                       (begin (consumeChar) (state8 (scanChar)))
                       (if ((lambda (c)
                              (and (char? c) (char=? c (integer->char 171))))
                            c)
                           (begin (consumeChar) (state8 (scanChar)))
                           (scannerError errIncompleteToken)))))))))
  (define (state8 c)
    (case c
      ((#\") (consumeChar) (accept 'string))
      ((#\newline #\return)
       (consumeChar)
       (state8 (scanChar)))
      ((#\\) (consumeChar) (state7 (scanChar)))
      (else (begin (consumeChar) (state8 (scanChar))))))
  (define (state9 c)
    (case c
      ((#\;) (consumeChar) (state12 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state9 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state10 c)
    (case c
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state9 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state11 c)
    (case c
      ((#\a #\b #\t #\n #\r #\\ #\" #\|)
       (consumeChar)
       (state12 (scanChar)))
      ((#\x) (consumeChar) (state10 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state12 c)
    (case c
      ((#\|) (consumeChar) (accept 'id))
      ((#\\) (consumeChar) (state11 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (not (char=? c #\|))
                   (not (char=? c #\\))))
            c)
           (begin (consumeChar) (state12 (scanChar)))
           (scannerError errIncompleteToken)))))
  (define (state13 c)
    (case c
      ((#\x) (consumeChar) (state72 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state14 c)
    (case c
      ((#\@) (consumeChar) (accept 'splicing))
      (else (accept 'comma))))
  (define (state15 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state123 (scanChar)))
      ((#\.
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\@
        #\+
        #\-)
       (consumeChar)
       (state74 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (> (char->integer c) 127)
                   (let ((cat (char-general-category c)))
                     (memq cat
                           '(Lu Ll
                                Lt
                                Lm
                                Lo
                                Mn
                                Nl
                                No
                                Pd
                                Pc
                                Po
                                Sc
                                Sm
                                Sk
                                So
                                Co)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (accept 'period)))))
  (define (state16 c)
    (case c
      ((#\@) (consumeChar) (state191 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state134 (scanChar)))
      ((#\#) (consumeChar) (state133 (scanChar)))
      ((#\/) (consumeChar) (state132 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state128 (scanChar)))
      ((#\|) (consumeChar) (state125 (scanChar)))
      ((#\.) (consumeChar) (state123 (scanChar)))
      ((#\+ #\-) (consumeChar) (state17 (scanChar)))
      (else (accept 'number))))
  (define (state17 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state169 (scanChar)))
      ((#\.) (consumeChar) (state157 (scanChar)))
      ((#\n #\N) (consumeChar) (state156 (scanChar)))
      ((#\i #\I) (consumeChar) (state151 (scanChar)))
      (else (accept 'id))))
  (define (state18 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state196 (scanChar)))
      ((#\#) (consumeChar) (state195 (scanChar)))
      ((#\/) (consumeChar) (state194 (scanChar)))
      ((#\@) (consumeChar) (state191 (scanChar)))
      ((#\-) (consumeChar) (state170 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state148 (scanChar)))
      ((#\|) (consumeChar) (state145 (scanChar)))
      ((#\.) (consumeChar) (state143 (scanChar)))
      ((#\+) (consumeChar) (state17 (scanChar)))
      (else (accept 'number))))
  (define (state19 c)
    (case c
      ((#\0 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state196 (scanChar)))
      ((#\.) (consumeChar) (state75 (scanChar)))
      ((#\-
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\j
        #\k
        #\l
        #\m
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\J
        #\K
        #\L
        #\M
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\@
        #\+)
       (consumeChar)
       (state74 (scanChar)))
      ((#\n #\N) (consumeChar) (state69 (scanChar)))
      ((#\i #\I) (consumeChar) (state21 (scanChar)))
      ((#\1) (consumeChar) (state18 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (> (char->integer c) 127)
                   (let ((cat (char-general-category c)))
                     (memq cat
                           '(Lu Ll
                                Lt
                                Lm
                                Lo
                                Mn
                                Nl
                                No
                                Pd
                                Pc
                                Po
                                Sc
                                Sm
                                Sk
                                So
                                Co)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (accept 'id)))))
  (define (state20 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\f #\F) (consumeChar) (state67 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state21 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\n #\N) (consumeChar) (state20 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'number)))))))
  (define (state22 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\f #\F) (consumeChar) (state26 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state23 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\n #\N) (consumeChar) (state22 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'number)))))))
  (define (state24 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\i #\I) (consumeChar) (state45 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state25 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\0) (consumeChar) (state24 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state26 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\.) (consumeChar) (state25 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state27 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\n #\N) (consumeChar) (state26 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state28 c)
    (case c
      ((#\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\a #\A) (consumeChar) (state27 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state29 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state36 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state30 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\i #\I) (consumeChar) (state45 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state30 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state31 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state30 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state32 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\i #\I) (consumeChar) (state45 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state32 (scanChar)))
      ((#\|) (consumeChar) (state31 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state33 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state32 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state34 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\+ #\-) (consumeChar) (state33 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state32 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state35 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state164 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state163 (scanChar)))
      ((#\|) (consumeChar) (state160 (scanChar)))
      ((#\%) (consumeChar) (state74 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state36 c)
    (case c
      ((#\a
        #\b
        #\c
        #\g
        #\h
        #\j
        #\k
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\G
        #\H
        #\J
        #\K
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\i #\I) (consumeChar) (state45 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state36 (scanChar)))
      ((#\#) (consumeChar) (state35 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state34 (scanChar)))
      ((#\|) (consumeChar) (state31 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state37 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state165 (scanChar)))
      ((#\%) (consumeChar) (state74 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state38 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\i #\I) (consumeChar) (state45 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state38 (scanChar)))
      ((#\#) (consumeChar) (state37 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state39 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state38 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state40 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state168 (scanChar)))
      ((#\/) (consumeChar) (state167 (scanChar)))
      ((#\.) (consumeChar) (state164 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state163 (scanChar)))
      ((#\|) (consumeChar) (state160 (scanChar)))
      ((#\%) (consumeChar) (state74 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state41 c)
    (case c
      ((#\a
        #\b
        #\c
        #\g
        #\h
        #\j
        #\k
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\G
        #\H
        #\J
        #\K
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\@)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\i #\I) (consumeChar) (state45 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state41 (scanChar)))
      ((#\#) (consumeChar) (state40 (scanChar)))
      ((#\/) (consumeChar) (state39 (scanChar)))
      ((#\.) (consumeChar) (state36 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state34 (scanChar)))
      ((#\|) (consumeChar) (state31 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state42 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\j
        #\k
        #\l
        #\m
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\J
        #\K
        #\L
        #\M
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state41 (scanChar)))
      ((#\.) (consumeChar) (state29 (scanChar)))
      ((#\n #\N) (consumeChar) (state28 (scanChar)))
      ((#\i #\I) (consumeChar) (state23 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state43 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\f #\F) (consumeChar) (state47 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state44 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\n #\N) (consumeChar) (state43 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state45 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'number)))))))
  (define (state46 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\0) (consumeChar) (state45 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state47 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\.) (consumeChar) (state46 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state48 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\n #\N) (consumeChar) (state47 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state49 c)
    (case c
      ((#\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\a #\A) (consumeChar) (state48 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state50 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state57 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state51 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state51 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'number)))))))
  (define (state52 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state51 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state53 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state53 (scanChar)))
      ((#\|) (consumeChar) (state52 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'number)))))))
  (define (state54 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state53 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state55 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\+ #\-) (consumeChar) (state54 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state53 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state56 c)
    (case c
      ((#\#) (consumeChar) (state184 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state183 (scanChar)))
      ((#\|) (consumeChar) (state180 (scanChar)))
      ((#\%) (consumeChar) (state74 (scanChar)))
      (else (accept 'number))))
  (define (state57 c)
    (case c
      ((#\a
        #\b
        #\c
        #\g
        #\h
        #\i
        #\j
        #\k
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\G
        #\H
        #\I
        #\J
        #\K
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state57 (scanChar)))
      ((#\#) (consumeChar) (state56 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state55 (scanChar)))
      ((#\|) (consumeChar) (state52 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'number)))))))
  (define (state58 c)
    (case c
      ((#\#) (consumeChar) (state185 (scanChar)))
      ((#\%) (consumeChar) (state74 (scanChar)))
      (else (accept 'number))))
  (define (state59 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state59 (scanChar)))
      ((#\#) (consumeChar) (state58 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'number)))))))
  (define (state60 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state59 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state61 c)
    (case c
      ((#\#) (consumeChar) (state188 (scanChar)))
      ((#\/) (consumeChar) (state187 (scanChar)))
      ((#\.) (consumeChar) (state184 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state183 (scanChar)))
      ((#\|) (consumeChar) (state180 (scanChar)))
      ((#\%) (consumeChar) (state74 (scanChar)))
      (else (accept 'number))))
  (define (state62 c)
    (case c
      ((#\a
        #\b
        #\c
        #\g
        #\h
        #\i
        #\j
        #\k
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\G
        #\H
        #\I
        #\J
        #\K
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\@)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state62 (scanChar)))
      ((#\#) (consumeChar) (state61 (scanChar)))
      ((#\/) (consumeChar) (state60 (scanChar)))
      ((#\.) (consumeChar) (state57 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state55 (scanChar)))
      ((#\|) (consumeChar) (state52 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'number)))))))
  (define (state63 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\j
        #\k
        #\l
        #\m
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\J
        #\K
        #\L
        #\M
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state62 (scanChar)))
      ((#\.) (consumeChar) (state50 (scanChar)))
      ((#\n #\N) (consumeChar) (state49 (scanChar)))
      ((#\i #\I) (consumeChar) (state44 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state64 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\+ #\-) (consumeChar) (state63 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state62 (scanChar)))
      ((#\.) (consumeChar) (state50 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state65 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\.
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\@) (consumeChar) (state64 (scanChar)))
      ((#\i #\I) (consumeChar) (state45 (scanChar)))
      ((#\+ #\-) (consumeChar) (state42 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'number)))))))
  (define (state66 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\0) (consumeChar) (state65 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state67 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\.) (consumeChar) (state66 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state68 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\n #\N) (consumeChar) (state67 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state69 c)
    (case c
      ((#\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      ((#\a #\A) (consumeChar) (state68 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state70 c)
    (case c
      ((#\%) (consumeChar) (state74 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state71 c)
    (case c
      ((#\;) (consumeChar) (state74 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state71 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state72 c)
    (case c
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state71 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state73 c)
    (case c
      ((#\x) (consumeChar) (state72 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c) (char<=? c (integer->char 127))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (scannerError errIncompleteToken)))))
  (define (state74 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@
        #\|)
       (consumeChar)
       (state74 (scanChar)))
      ((#\\) (consumeChar) (state73 (scanChar)))
      ((#\#) (consumeChar) (state70 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (<= 8204 (char->integer c) 8205)))
                c)
               (begin (consumeChar) (state74 (scanChar)))
               (if ((lambda (c)
                      (and (char? c)
                           (> (char->integer c) 127)
                           (let ((cat (char-general-category c)))
                             (memq cat
                                   '(Lu Ll
                                        Lt
                                        Lm
                                        Lo
                                        Mn
                                        Nl
                                        No
                                        Pd
                                        Pc
                                        Po
                                        Sc
                                        Sm
                                        Sk
                                        So
                                        Co)))))
                    c)
                   (begin (consumeChar) (state74 (scanChar)))
                   (accept 'id)))))))
  (define (state75 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state143 (scanChar)))
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\@
        #\+
        #\-
        #\.)
       (consumeChar)
       (state74 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (> (char->integer c) 127)
                   (let ((cat (char-general-category c)))
                     (memq cat
                           '(Lu Ll
                                Lt
                                Lm
                                Lo
                                Mn
                                Nl
                                No
                                Pd
                                Pc
                                Po
                                Sc
                                Sm
                                Sk
                                So
                                Co)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (scannerError errIncompleteToken)))))
  (define (state76 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state196 (scanChar)))
      ((#\.) (consumeChar) (state75 (scanChar)))
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\j
        #\k
        #\l
        #\m
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\J
        #\K
        #\L
        #\M
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\@
        #\+
        #\-)
       (consumeChar)
       (state74 (scanChar)))
      ((#\n #\N) (consumeChar) (state69 (scanChar)))
      ((#\i #\I) (consumeChar) (state21 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (> (char->integer c) 127)
                   (let ((cat (char-general-category c)))
                     (memq cat
                           '(Lu Ll
                                Lt
                                Lm
                                Lo
                                Mn
                                Nl
                                No
                                Pd
                                Pc
                                Po
                                Sc
                                Sm
                                Sk
                                So
                                Co)))))
            c)
           (begin (consumeChar) (state74 (scanChar)))
           (accept 'id)))))
  (define (state77 c)
    (case c
      ((#\" #\\) (consumeChar) (state78 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state78 c)
    (case c
      ((#\") (consumeChar) (accept 'xstring))
      ((#\\) (consumeChar) (state77 (scanChar)))
      (else (begin (consumeChar) (state78 (scanChar))))))
  (define (state79 c)
    (case c
      ((#\#) (consumeChar) (accept 'sharinguse))
      ((#\=) (consumeChar) (accept 'sharingdef))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state79 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state80 c)
    (case c
      ((#\@) (consumeChar) (accept 'unsyntaxsplicing))
      (else (accept 'unsyntax))))
  (define (state81 c)
    (case c
      ((#\() (consumeChar) (accept 'bvecstart))
      (else (scannerError errIncompleteToken))))
  (define (state82 c)
    (case c
      ((#\8) (consumeChar) (state81 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state83 c)
    (case c
      ((#\u) (consumeChar) (state82 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state84 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z)
       (consumeChar)
       (state84 (scanChar)))
      (else (accept 'character))))
  (define (state85 c)
    (case c
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state85 (scanChar)))
      (else (accept 'character))))
  (define (state86 c)
    (case c
      ((#\a #\b #\c #\d #\e #\f #\A #\B #\C #\D #\E #\F)
       (consumeChar)
       (state86 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state85 (scanChar)))
      ((#\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z)
       (consumeChar)
       (state84 (scanChar)))
      (else (accept 'character))))
  (define (state87 c)
    (case c
      ((#\x) (consumeChar) (state86 (scanChar)))
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z)
       (consumeChar)
       (state84 (scanChar)))
      (else
       (if (char? c)
           (begin (consumeChar) (accept 'character))
           (scannerError errIncompleteToken)))))
  (define (state88 c)
    (case c
      ((#\i #\I #\e #\E)
       (consumeChar)
       (state119 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state89 c)
    (case c
      ((#\+ #\-) (consumeChar) (state118 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state94 (scanChar)))
      ((#\#) (consumeChar) (state88 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state90 c)
    (case c
      ((#\@) (consumeChar) (state112 (scanChar)))
      ((#\+ #\-) (consumeChar) (state106 (scanChar)))
      ((#\#) (consumeChar) (state90 (scanChar)))
      (else (accept 'number))))
  (define (state91 c)
    (case c
      ((#\@) (consumeChar) (state112 (scanChar)))
      ((#\+ #\-) (consumeChar) (state106 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state91 (scanChar)))
      ((#\#) (consumeChar) (state90 (scanChar)))
      (else (accept 'number))))
  (define (state92 c)
    (case c
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state91 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state93 c)
    (case c
      ((#\@) (consumeChar) (state112 (scanChar)))
      ((#\+ #\-) (consumeChar) (state106 (scanChar)))
      ((#\#) (consumeChar) (state93 (scanChar)))
      ((#\/) (consumeChar) (state92 (scanChar)))
      (else (accept 'number))))
  (define (state94 c)
    (case c
      ((#\@) (consumeChar) (state112 (scanChar)))
      ((#\+ #\-) (consumeChar) (state106 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state94 (scanChar)))
      ((#\#) (consumeChar) (state93 (scanChar)))
      ((#\/) (consumeChar) (state92 (scanChar)))
      (else (accept 'number))))
  (define (state95 c)
    (case c
      ((#\f #\F) (consumeChar) (state99 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state96 c)
    (case c
      ((#\n #\N) (consumeChar) (state95 (scanChar)))
      (else (accept 'number))))
  (define (state97 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\@) (consumeChar) (state112 (scanChar)))
      ((#\+ #\-) (consumeChar) (state106 (scanChar)))
      (else (accept 'number))))
  (define (state98 c)
    (case c
      ((#\0) (consumeChar) (state97 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state99 c)
    (case c
      ((#\.) (consumeChar) (state98 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state100 c)
    (case c
      ((#\n #\N) (consumeChar) (state99 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state101 c)
    (case c
      ((#\a #\A) (consumeChar) (state100 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state102 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state165 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state102 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state103 c)
    (case c
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state102 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state104 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state104 (scanChar)))
      ((#\/) (consumeChar) (state103 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state105 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state105 (scanChar)))
      ((#\#) (consumeChar) (state104 (scanChar)))
      ((#\/) (consumeChar) (state103 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state106 c)
    (case c
      ((#\n #\N) (consumeChar) (state156 (scanChar)))
      ((#\i #\I) (consumeChar) (state151 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state105 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state107 c)
    (case c
      ((#\#) (consumeChar) (state185 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state107 (scanChar)))
      (else (accept 'number))))
  (define (state108 c)
    (case c
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state107 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state109 c)
    (case c
      ((#\#) (consumeChar) (state109 (scanChar)))
      ((#\/) (consumeChar) (state108 (scanChar)))
      (else (accept 'number))))
  (define (state110 c)
    (case c
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state110 (scanChar)))
      ((#\#) (consumeChar) (state109 (scanChar)))
      ((#\/) (consumeChar) (state108 (scanChar)))
      (else (accept 'number))))
  (define (state111 c)
    (case c
      ((#\n #\N) (consumeChar) (state176 (scanChar)))
      ((#\i #\I) (consumeChar) (state172 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state110 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state112 c)
    (case c
      ((#\+ #\-) (consumeChar) (state111 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state110 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state113 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state113 (scanChar)))
      ((#\@) (consumeChar) (state112 (scanChar)))
      ((#\+ #\-) (consumeChar) (state106 (scanChar)))
      (else (accept 'number))))
  (define (state114 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state114 (scanChar)))
      ((#\#) (consumeChar) (state113 (scanChar)))
      ((#\@) (consumeChar) (state112 (scanChar)))
      ((#\+ #\-) (consumeChar) (state106 (scanChar)))
      (else (accept 'number))))
  (define (state115 c)
    (case c
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state114 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state116 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state116 (scanChar)))
      ((#\/) (consumeChar) (state115 (scanChar)))
      ((#\@) (consumeChar) (state112 (scanChar)))
      ((#\+ #\-) (consumeChar) (state106 (scanChar)))
      (else (accept 'number))))
  (define (state117 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state117 (scanChar)))
      ((#\#) (consumeChar) (state116 (scanChar)))
      ((#\/) (consumeChar) (state115 (scanChar)))
      ((#\@) (consumeChar) (state112 (scanChar)))
      ((#\+ #\-) (consumeChar) (state106 (scanChar)))
      (else (accept 'number))))
  (define (state118 c)
    (case c
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state117 (scanChar)))
      ((#\n #\N) (consumeChar) (state101 (scanChar)))
      ((#\i #\I) (consumeChar) (state96 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state119 c)
    (case c
      ((#\+ #\-) (consumeChar) (state118 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state94 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state120 c)
    (case c
      ((#\d #\D) (consumeChar) (state198 (scanChar)))
      ((#\b #\B #\o #\O #\x #\X)
       (consumeChar)
       (state119 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state121 c)
    (case c
      ((#\+ #\-) (consumeChar) (state197 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state134 (scanChar)))
      ((#\.) (consumeChar) (state122 (scanChar)))
      ((#\#) (consumeChar) (state120 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state122 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state123 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state123 c)
    (case c
      ((#\@) (consumeChar) (state191 (scanChar)))
      ((#\+ #\-) (consumeChar) (state170 (scanChar)))
      ((#\#) (consumeChar) (state129 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state128 (scanChar)))
      ((#\|) (consumeChar) (state125 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state123 (scanChar)))
      (else (accept 'number))))
  (define (state124 c)
    (case c
      ((#\@) (consumeChar) (state191 (scanChar)))
      ((#\+ #\-) (consumeChar) (state170 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state124 (scanChar)))
      (else (accept 'number))))
  (define (state125 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state124 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state126 c)
    (case c
      ((#\@) (consumeChar) (state191 (scanChar)))
      ((#\+ #\-) (consumeChar) (state170 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state126 (scanChar)))
      ((#\|) (consumeChar) (state125 (scanChar)))
      (else (accept 'number))))
  (define (state127 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state126 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state128 c)
    (case c
      ((#\+ #\-) (consumeChar) (state127 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state126 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state129 c)
    (case c
      ((#\@) (consumeChar) (state191 (scanChar)))
      ((#\+ #\-) (consumeChar) (state170 (scanChar)))
      ((#\#) (consumeChar) (state129 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state128 (scanChar)))
      ((#\|) (consumeChar) (state125 (scanChar)))
      (else (accept 'number))))
  (define (state130 c)
    (case c
      ((#\@) (consumeChar) (state191 (scanChar)))
      ((#\+ #\-) (consumeChar) (state170 (scanChar)))
      ((#\#) (consumeChar) (state130 (scanChar)))
      (else (accept 'number))))
  (define (state131 c)
    (case c
      ((#\@) (consumeChar) (state191 (scanChar)))
      ((#\+ #\-) (consumeChar) (state170 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state131 (scanChar)))
      ((#\#) (consumeChar) (state130 (scanChar)))
      (else (accept 'number))))
  (define (state132 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state131 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state133 c)
    (case c
      ((#\@) (consumeChar) (state191 (scanChar)))
      ((#\+ #\-) (consumeChar) (state170 (scanChar)))
      ((#\#) (consumeChar) (state133 (scanChar)))
      ((#\/) (consumeChar) (state132 (scanChar)))
      ((#\.) (consumeChar) (state129 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state128 (scanChar)))
      ((#\|) (consumeChar) (state125 (scanChar)))
      (else (accept 'number))))
  (define (state134 c)
    (case c
      ((#\@) (consumeChar) (state191 (scanChar)))
      ((#\+ #\-) (consumeChar) (state170 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state134 (scanChar)))
      ((#\#) (consumeChar) (state133 (scanChar)))
      ((#\/) (consumeChar) (state132 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state128 (scanChar)))
      ((#\|) (consumeChar) (state125 (scanChar)))
      ((#\.) (consumeChar) (state123 (scanChar)))
      (else (accept 'number))))
  (define (state135 c)
    (case c
      ((#\f #\F) (consumeChar) (state139 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state136 c)
    (case c
      ((#\n #\N) (consumeChar) (state135 (scanChar)))
      (else (accept 'number))))
  (define (state137 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\@) (consumeChar) (state191 (scanChar)))
      ((#\+ #\-) (consumeChar) (state170 (scanChar)))
      (else (accept 'number))))
  (define (state138 c)
    (case c
      ((#\0) (consumeChar) (state137 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state139 c)
    (case c
      ((#\.) (consumeChar) (state138 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state140 c)
    (case c
      ((#\n #\N) (consumeChar) (state139 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state141 c)
    (case c
      ((#\a #\A) (consumeChar) (state140 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state142 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state143 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state143 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\@) (consumeChar) (state191 (scanChar)))
      ((#\+ #\-) (consumeChar) (state170 (scanChar)))
      ((#\#) (consumeChar) (state149 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state148 (scanChar)))
      ((#\|) (consumeChar) (state145 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state143 (scanChar)))
      (else (accept 'number))))
  (define (state144 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\@) (consumeChar) (state191 (scanChar)))
      ((#\+ #\-) (consumeChar) (state170 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state144 (scanChar)))
      (else (accept 'number))))
  (define (state145 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state144 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state146 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\@) (consumeChar) (state191 (scanChar)))
      ((#\+ #\-) (consumeChar) (state170 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state146 (scanChar)))
      ((#\|) (consumeChar) (state145 (scanChar)))
      (else (accept 'number))))
  (define (state147 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state146 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state148 c)
    (case c
      ((#\+ #\-) (consumeChar) (state147 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state146 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state149 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\@) (consumeChar) (state191 (scanChar)))
      ((#\+ #\-) (consumeChar) (state170 (scanChar)))
      ((#\#) (consumeChar) (state149 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state148 (scanChar)))
      ((#\|) (consumeChar) (state145 (scanChar)))
      (else (accept 'number))))
  (define (state150 c)
    (case c
      ((#\f #\F) (consumeChar) (state154 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state151 c)
    (case c
      ((#\n #\N) (consumeChar) (state150 (scanChar)))
      (else (accept 'number))))
  (define (state152 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      (else (scannerError errIncompleteToken))))
  (define (state153 c)
    (case c
      ((#\0) (consumeChar) (state152 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state154 c)
    (case c
      ((#\.) (consumeChar) (state153 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state155 c)
    (case c
      ((#\n #\N) (consumeChar) (state154 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state156 c)
    (case c
      ((#\a #\A) (consumeChar) (state155 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state157 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state158 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state158 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state164 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state163 (scanChar)))
      ((#\|) (consumeChar) (state160 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state158 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state159 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state159 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state160 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state159 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state161 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state161 (scanChar)))
      ((#\|) (consumeChar) (state160 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state162 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state161 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state163 c)
    (case c
      ((#\+ #\-) (consumeChar) (state162 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state161 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state164 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state164 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state163 (scanChar)))
      ((#\|) (consumeChar) (state160 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state165 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state165 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state166 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state166 (scanChar)))
      ((#\#) (consumeChar) (state165 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state167 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state166 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state168 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state168 (scanChar)))
      ((#\/) (consumeChar) (state167 (scanChar)))
      ((#\.) (consumeChar) (state164 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state163 (scanChar)))
      ((#\|) (consumeChar) (state160 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state169 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state169 (scanChar)))
      ((#\#) (consumeChar) (state168 (scanChar)))
      ((#\/) (consumeChar) (state167 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state163 (scanChar)))
      ((#\|) (consumeChar) (state160 (scanChar)))
      ((#\.) (consumeChar) (state158 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state170 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state169 (scanChar)))
      ((#\.) (consumeChar) (state157 (scanChar)))
      ((#\n #\N) (consumeChar) (state156 (scanChar)))
      ((#\i #\I) (consumeChar) (state151 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state171 c)
    (case c
      ((#\f #\F) (consumeChar) (state174 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state172 c)
    (case c
      ((#\n #\N) (consumeChar) (state171 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state173 c)
    (case c
      ((#\0) (consumeChar) (accept 'number))
      (else (scannerError errIncompleteToken))))
  (define (state174 c)
    (case c
      ((#\.) (consumeChar) (state173 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state175 c)
    (case c
      ((#\n #\N) (consumeChar) (state174 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state176 c)
    (case c
      ((#\a #\A) (consumeChar) (state175 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state177 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state178 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state178 c)
    (case c
      ((#\#) (consumeChar) (state184 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state183 (scanChar)))
      ((#\|) (consumeChar) (state180 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state178 (scanChar)))
      (else (accept 'number))))
  (define (state179 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state179 (scanChar)))
      (else (accept 'number))))
  (define (state180 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state179 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state181 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state181 (scanChar)))
      ((#\|) (consumeChar) (state180 (scanChar)))
      (else (accept 'number))))
  (define (state182 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state181 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state183 c)
    (case c
      ((#\+ #\-) (consumeChar) (state182 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state181 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state184 c)
    (case c
      ((#\#) (consumeChar) (state184 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state183 (scanChar)))
      ((#\|) (consumeChar) (state180 (scanChar)))
      (else (accept 'number))))
  (define (state185 c)
    (case c
      ((#\#) (consumeChar) (state185 (scanChar)))
      (else (accept 'number))))
  (define (state186 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state186 (scanChar)))
      ((#\#) (consumeChar) (state185 (scanChar)))
      (else (accept 'number))))
  (define (state187 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state186 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state188 c)
    (case c
      ((#\#) (consumeChar) (state188 (scanChar)))
      ((#\/) (consumeChar) (state187 (scanChar)))
      ((#\.) (consumeChar) (state184 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state183 (scanChar)))
      ((#\|) (consumeChar) (state180 (scanChar)))
      (else (accept 'number))))
  (define (state189 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state189 (scanChar)))
      ((#\#) (consumeChar) (state188 (scanChar)))
      ((#\/) (consumeChar) (state187 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state183 (scanChar)))
      ((#\|) (consumeChar) (state180 (scanChar)))
      ((#\.) (consumeChar) (state178 (scanChar)))
      (else (accept 'number))))
  (define (state190 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state189 (scanChar)))
      ((#\.) (consumeChar) (state177 (scanChar)))
      ((#\n #\N) (consumeChar) (state176 (scanChar)))
      ((#\i #\I) (consumeChar) (state172 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state191 c)
    (case c
      ((#\+ #\-) (consumeChar) (state190 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state189 (scanChar)))
      ((#\.) (consumeChar) (state177 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state192 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state192 (scanChar)))
      ((#\@) (consumeChar) (state191 (scanChar)))
      ((#\+ #\-) (consumeChar) (state170 (scanChar)))
      (else (accept 'number))))
  (define (state193 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state193 (scanChar)))
      ((#\#) (consumeChar) (state192 (scanChar)))
      ((#\@) (consumeChar) (state191 (scanChar)))
      ((#\+ #\-) (consumeChar) (state170 (scanChar)))
      (else (accept 'number))))
  (define (state194 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state193 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state195 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state195 (scanChar)))
      ((#\/) (consumeChar) (state194 (scanChar)))
      ((#\@) (consumeChar) (state191 (scanChar)))
      ((#\+ #\-) (consumeChar) (state170 (scanChar)))
      ((#\.) (consumeChar) (state149 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state148 (scanChar)))
      ((#\|) (consumeChar) (state145 (scanChar)))
      (else (accept 'number))))
  (define (state196 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state196 (scanChar)))
      ((#\#) (consumeChar) (state195 (scanChar)))
      ((#\/) (consumeChar) (state194 (scanChar)))
      ((#\@) (consumeChar) (state191 (scanChar)))
      ((#\+ #\-) (consumeChar) (state170 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state148 (scanChar)))
      ((#\|) (consumeChar) (state145 (scanChar)))
      ((#\.) (consumeChar) (state143 (scanChar)))
      (else (accept 'number))))
  (define (state197 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state196 (scanChar)))
      ((#\.) (consumeChar) (state142 (scanChar)))
      ((#\n #\N) (consumeChar) (state141 (scanChar)))
      ((#\i #\I) (consumeChar) (state136 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state198 c)
    (case c
      ((#\+ #\-) (consumeChar) (state197 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state134 (scanChar)))
      ((#\.) (consumeChar) (state122 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state199 c)
    (case c
      ((#\i #\I #\e #\E)
       (consumeChar)
       (state198 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state200 c)
    (case c
      ((#\#) (consumeChar) (state199 (scanChar)))
      ((#\+ #\-) (consumeChar) (state197 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state134 (scanChar)))
      ((#\.) (consumeChar) (state122 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state201 c)
    (case c
      ((#\s #\S) (consumeChar) (state204 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state202 c)
    (case c
      ((#\l #\L) (consumeChar) (state201 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state203 c)
    (case c
      ((#\a #\A) (consumeChar) (state202 (scanChar)))
      (else (accept 'boolean))))
  (define (state204 c)
    (case c
      ((#\e #\E) (consumeChar) (accept 'boolean))
      (else (scannerError errIncompleteToken))))
  (define (state205 c)
    (case c
      ((#\u #\U) (consumeChar) (state204 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state206 c)
    (case c
      ((#\r #\R) (consumeChar) (state205 (scanChar)))
      (else (accept 'boolean))))
  (define (state207 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\-)
       (consumeChar)
       (state207 (scanChar)))
      (else (accept 'miscflag))))
  (define (state208 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z)
       (consumeChar)
       (state207 (scanChar)))
      (else (accept 'xcomment))))
  (define (state209 c)
    (case c
      ((#\&) (consumeChar) (accept 'xbox))
      ((#\.) (consumeChar) (accept 'xsharpdot))
      ((#\`) (consumeChar) (accept 'quasisyntax))
      ((#\') (consumeChar) (accept 'syntax))
      ((#\() (consumeChar) (accept 'vecstart))
      ((#\;) (consumeChar) (accept 'commentdatum))
      ((#\|) (consumeChar) (accept 'comment))
      ((#\!) (consumeChar) (state208 (scanChar)))
      ((#\t #\T) (consumeChar) (state206 (scanChar)))
      ((#\f #\F) (consumeChar) (state203 (scanChar)))
      ((#\d #\D) (consumeChar) (state200 (scanChar)))
      ((#\i #\I #\e #\E)
       (consumeChar)
       (state121 (scanChar)))
      ((#\b #\B #\o #\O #\x #\X)
       (consumeChar)
       (state89 (scanChar)))
      ((#\\) (consumeChar) (state87 (scanChar)))
      ((#\v) (consumeChar) (state83 (scanChar)))
      ((#\u) (consumeChar) (state82 (scanChar)))
      ((#\,) (consumeChar) (state80 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state79 (scanChar)))
      ((#\") (consumeChar) (state78 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c) (char=? c (integer->char 16))))
            c)
           (begin (consumeChar) (accept 'xfaslp))
           (if ((lambda (c)
                  (and (char? c) (char=? c (integer->char 7))))
                c)
               (begin (consumeChar) (accept 'xfaslg))
               (if ((lambda (c)
                      (and (char? c) (char=? c (integer->char 6))))
                    c)
                   (begin (consumeChar) (accept 'xfaslf))
                   (if ((lambda (c)
                          (and (char? c) (char=? c (integer->char 3))))
                        c)
                       (begin (consumeChar) (accept 'xfaslc))
                       (if ((lambda (c)
                              (and (char? c) (char=? c (integer->char 2))))
                            c)
                           (begin (consumeChar) (accept 'xfaslb))
                           (scannerError errIncompleteToken)))))))))
  (define (state210 c)
    (case c
      (else
       (if ((lambda (c)
              (and (char? c)
                   (not (char=? c (integer->char 10)))
                   (not (char=? c (integer->char 13)))
                   (not (char=? c (integer->char 133)))
                   (not (char=? c (integer->char 8232)))))
            c)
           (begin (consumeChar) (state210 (scanChar)))
           (begin
             (set! string_accumulator_length 0)
             (state0 (scanChar)))))))
  (define (state211 c)
    (case c
      (else
       (begin
         (set! string_accumulator_length 0)
         (state0 (scanChar))))))
  (define (state212 c)
    (case c (else (accept 'comment))))
  (define (state213 c)
    (case c (else (accept 'commentdatum))))
  (define (state214 c)
    (case c (else (accept 'boolean))))
  (define (state215 c)
    (case c (else (accept 'number))))
  (define (state216 c)
    (case c (else (accept 'character))))
  (define (state217 c)
    (case c (else (accept 'vecstart))))
  (define (state218 c)
    (case c (else (accept 'bvecstart))))
  (define (state219 c)
    (case c (else (accept 'syntax))))
  (define (state220 c)
    (case c (else (accept 'quasisyntax))))
  (define (state221 c)
    (case c (else (accept 'unsyntaxsplicing))))
  (define (state222 c)
    (case c (else (accept 'sharingdef))))
  (define (state223 c)
    (case c (else (accept 'sharinguse))))
  (define (state224 c)
    (case c (else (accept 'xfaslb))))
  (define (state225 c)
    (case c (else (accept 'xfaslc))))
  (define (state226 c)
    (case c (else (accept 'xfaslf))))
  (define (state227 c)
    (case c (else (accept 'xfaslg))))
  (define (state228 c)
    (case c (else (accept 'xfaslp))))
  (define (state229 c)
    (case c (else (accept 'xsharpdot))))
  (define (state230 c)
    (case c (else (accept 'xbox))))
  (define (state231 c)
    (case c (else (accept 'xstring))))
  (define (state232 c)
    (case c (else (accept 'eofobj))))
  (define (state233 c)
    (case c (else (accept 'lparen))))
  (define (state234 c)
    (case c (else (accept 'rparen))))
  (define (state235 c)
    (case c (else (accept 'lbracket))))
  (define (state236 c)
    (case c (else (accept 'rbracket))))
  (define (state237 c)
    (case c (else (accept 'quote))))
  (define (state238 c)
    (case c (else (accept 'backquote))))
  (define (state239 c)
    (case c (else (accept 'splicing))))
  (define (state240 c)
    (case c (else (accept 'id))))
  (define (state241 c)
    (case c (else (accept 'string))))
  (define (state242 c)
    (case c (else (accept 'text))))

  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;
  ; End of state machine generated by LexGen.
  ;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  (lambda (c) (state0 c)))

;;; eof
